<#
PowerShell teremkontroll - alapozo
F.E.K. 2024.02.19
#>

$konfig = 'alapok.cfg'

$host.ui.RawUI.WindowTitle="Teremkontroll - alapozo"
$Global:status = "HIBA"
$minimumkonfig = @('ver','ladmin','dadmin','celdomain','segedekhelye','parancslista','telepitoforras','telepitocel','loghelye','kihagyandok')
$minimumfile = @('ladmin','dadmin','parancslista')

Write-Host "`n"
if(!(Test-Path "$konfig"))
		{
		 Write-Host "$konfig nem elerheto!" 
		 exit
		}

if ($args[0] -eq $null) {
		          Write-Host "Parancssori parameter hianyzik!"
			  Write-Host "Minta: $Global:scriptnev teremszam`n"
			  exit
			}

if(!(Test-Path "$args"))
		{
		 Write-Host "Teremszam file: $args nem elerheto!`n" 
		 exit
		}

$GLobal:teremkonfig = Get-Content -Path $konfig | ConvertFrom-Json

foreach ($aktualis in $minimumkonfig)
			 {
			   if ( $GLobal:teremkonfig.$aktualis -eq $null) 
				{
				 Write-Host "Hianyzo ervenyes $konfig bejegyzes: $aktualis"
				 exit
				}
			 }

foreach ($aktualis in $minimumfile)
			  {
			   if  (!( Test-Path -Path $GLobal:teremkonfig.$aktualis )) 
				       {
					Write-Host "Kritikus file: $aktualis nem elerheto!`n"
					exit
				       }
			  }

if (!( Test-Path -Path $GLobal:teremkonfig.segedekhelye )) 
				{
				 Write-Host "segedprogramok mappa: $($GLobal:teremkonfig.segedekhelye) nem elerheto!"
				 exit
				}

if (!( Test-Path -Path $GLobal:teremkonfig.loghelye )) 
				{
				 New-Item -ItemType Directory -Force -Path $GLobal:teremkonfig.loghelye | Out-Null
				}

$Global:domaincred = Import-Clixml -Path $GLobal:teremkonfig.dadmin
$Global:localcred = Import-Clixml -Path $GLobal:teremkonfig.ladmin
$Global:gepterem = Import-CSV -Path $args[0] -Header "ip","mac","gepnev" -Delimiter ","
$Global:status = "OK"