<#
PowerShell teremkontroll - vegrehajto
F.E.K. 2024.02.19
#>

$konfig = 'alapok.cfg'
$host.ui.RawUI.WindowTitle="Teremkontroll - vegrehajto - $($args[1])"

if ($args[2] -eq $null) {
		         Write-Host "`n A modul - $($MyInvocation.MyCommand.Name) - onnmagaban nem hivhato meg!"  
			 exit
			}
$help = {
	 Write-Host "`nHIBA: teremszam file hianyzik vagy ervenytelen!"
	 Write-Host "`n - hasznalat: $($MyInvocation.MyCommand.Name) teremszam`n"
	 exit
	}

if(!(Test-Path "$konfig")) {
			     Write-Host "`n$konfig nem elerheto!`n" 
			     exit
			    }

if ($args[0] -eq $null) {&$help}

$teremkonfig = Get-Content -Path $konfig | ConvertFrom-Json
$localcred = Import-Clixml -Path ($teremkonfig.ladmin)
$log = "$($teremkonfig.loghelye)\$($args[1]).log"
$parancsok = Get-Content -Path "$($teremkonfig.parancslista)"
$pcsession = New-PSSession -ComputerName $($args[1]) -Credential ($localcred)

"`nParancsvegrehajtas, $($teremkonfig.ver), inditva: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss"), cel: $($args[1]) `n" | Tee-Object -Append -FilePath "$log"

Copy-Item -Path "$($teremkonfig.telepitoforras)" -Destination "$($teremkonfig.telepitocel)" -ToSession $pcsession -Verbose -Force

"File-ok masolasa...`n" | Tee-Object -Append -FilePath "$log"
$filelist = $(Get-ChildItem -Path "$($teremkonfig.telepitoforras)" -Recurse -Name)

foreach ($aktualis in $filelist)
		{
		$aktualis | Tee-Object -Append -FilePath "$log"
		Copy-Item -Path "$($teremkonfig.telepitoforras)\$aktualis" -Destination "$($teremkonfig.telepitocel)\$aktualis" -ToSession $pcsession -Verbose -Force
		}

"`nTavoli gepen parancs kiadva:" | Tee-Object -Append -FilePath "$log"

foreach ($aktualis in $parancsok)
		{
		$cmdp = "/c $aktualis"
		"$aktualis" | Tee-Object -Append -FilePath "$log"
		Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ArgumentLis $cmdp -ScriptBlock { param ($cmdp), (Start-Process cmd.exe -Args $cmdp -Wait) }
		}

"`nTavoli gepen mappa: $($teremkonfig.telepitocel) torlese..." | Tee-Object -Append -FilePath "$log"
Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ArgumentLis $($teremkonfig.telepitocel) -ScriptBlock { param ($tavoli), (remove-item -Path $tavoli -Recurse) }

$pcsession | Remove-PSSession
Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ScriptBlock { Stop-Computer -Force } *>&1 | Tee-Object -Append -FilePath "$log"

"`nParancsvegrehajtas, $($teremkonfig.ver), lefutott: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss"), cel: $($args[1])" | Tee-Object -Append -FilePath "$log"
