<#
PowerShell teremkontroll - profiltorles
F.E.K. 2024.02.24
#>

$konfig = 'alapok.cfg'
$host.ui.RawUI.WindowTitle="Teremkontroll - profiltorles - $($args[1])"

if ($args[2] -eq $null) {
		         Write-Host "`n A modul - $($MyInvocation.MyCommand.Name) - onnmagaban nem hivhato meg!"  
			 exit
			}
$help = {
	 Write-Host "`nHIBA: teremszam file hianyzik vagy ervenytelen!"
	 Write-Host "`n - hasznalat: $($MyInvocation.MyCommand.Name) teremszam`n"
	 exit
	}

if(!(Test-Path "$konfig")) {
			     Write-Host "`n$konfig nem elerheto!`n" 
			     exit
			    }

if ($args[0] -eq $null) {&$help}

$teremkonfig = Get-Content -Path $konfig | ConvertFrom-Json
$localcred = Import-Clixml -Path ($teremkonfig.ladmin)
$log = "$($teremkonfig.loghelye)\$($args[1]).log"

"Profiltroles, $($teremkonfig.ver), inditva: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss"), cel: $($args[1]) `n" | Tee-Object -Append -FilePath "$log"

$profilok  = ($((Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ScriptBlock { Get-WmiObject -Class Win32_UserProfile|select-object LocalPath|out-string -stream|select-string -notmatch "Windows"|select-string "Users"| format-table -HideTableHeaders -Property Line|out-string}) -replace '\s+',';') -replace '^;','').Split(";")
foreach ($aktualis in $profilok)
	{
	 $vizsgal = ($($aktualis -split "\\")[-1]) -replace '\s',''
	  if (!($teremkonfig.kihagyandok.Contains($vizsgal)))
			{
			 "Profil torlese: $aktualis"| Tee-Object -Append -FilePath "$log"
			 Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ArgumentList $aktualis,$vizsgal -ScriptBlock { param ($aktualis,$vizsgal), (Get-WmiObject -Class Win32_UserProfile | Where-Object {$_.LocalPath -eq $aktualis} | Remove-WmiObject) }
			} 
	 }

"`nProfiltroles, lefutott: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss")`n" | Tee-Object -Append -FilePath "$log"
Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ScriptBlock { (Stop-Computer -Force) }
"Leallitva: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss"), cel: $($args[1]) `n" | Tee-Object -Append -FilePath "$log"
