<#
PowerShell teremkontroll - domain
F.E.K. 2024.02.19
#>

$konfig = 'alapok.cfg'
$host.ui.RawUI.WindowTitle="Teremkontroll - domain-be - $($args[1])"

if ($args[2] -eq $null) {
		         Write-Host "`n A modul - $($MyInvocation.MyCommand.Name) - onnmagaban nem hivhato meg!"  
			 exit
			}

$help = {
	 Write-Host "`nHIBA: teremszam file hianyzik vagy ervenytelen!"
	 Write-Host "`n - hasznalat: $($MyInvocation.MyCommand.Name) teremszam`n"
	 exit
	}

if(!(Test-Path "$konfig")) {
			     Write-Host "`n$konfig nem elerheto!`n" 
			     exit
			    }

if ($args[0] -eq $null) {&$help}

$teremkonfig = Get-Content -Path $konfig | ConvertFrom-Json
$domaincred = Import-Clixml -Path ($teremkonfig.dadmin)
$localcred = Import-Clixml -Path ($teremkonfig.ladmin)
$log = "$($teremkonfig.loghelye)\$($args[1]).log"

"Domain beleptetes $($teremkonfig.ver), inditva: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss"), cel: $($args[1]) `n" | Tee-Object -Append -FilePath "$log"
Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ArgumentList $($args[2]) -ScriptBlock { param ($ujnev), (Rename-Computer -Newname $($ujnev) ), (Restart-Computer -Force) } *>&1 | Tee-Object -Append -FilePath "$log"

"`n60 sec biztonsagi varakozas..." | Tee-Object -Append -FilePath "$log"
Start-Sleep -Seconds 60 *>&1 | Tee-Object -Append -FilePath "$log"

Invoke-Command -ComputerName $($args[1]) -Credential ($localcred) -ArgumentList $($teremkonfig.celdomain),$domaincred -ScriptBlock { param ($celdomain,$domaincred), (Add-Computer -DomainName ($celdomain) -Credential ($domaincred) -Force -PassThru), (Stop-Computer -Force) }  *>&1 | Tee-Object -Append -FilePath "$log"
"Domain beleptetes, lefutott: $(Get-Date -Format "yyyy.MM.dd_HH:mm:ss")`n`n" | Tee-Object -Append -FilePath "$log"
