#!/bin/bash
#Created By F.E.K.
#2019.10.18

ver=V1.8
log=$1_migral.log
declare -A alapkonfig
declare -A ldapadat
declare -A zimbraadat
eredetiIFS=$IFS

 if [ ! -f alapok.cfg ];then echo -e "\n\033[0;31mAlapok.cfg nem található!\033[0m\n";exit;fi
 if [ ! -f .idf ];then echo -e "\n\033[0;31mIDF állomány nem található!\033[0m\n";exit;fi
 if [ -z "${1// }" ] || [[ ${#1} != 6 ]] || [[ $1 =~ [^[:alnum:]] ]];then echo -e "\n\033[0;31mAdd meg a neptun azonosítót!\033[0m (6 szám és/vagy betű) $1\n";exit;fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
 if [[ $igazitottertek = :* ]];then igazitottertek=$(echo $igazitottertek|awk -F " " '{print $2}'|base64 --decode 2>&1);fi
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
  if [[ $igazitottkulcs == "tartomany" ]];then tartomany+=($igazitottertek)
                                        else
                                        if ! [[ -z "$igazitottkulcs" ]];then alapkonfig[$igazitottkulcs]=$igazitottertek;fi
fi
done < alapok.cfg

 if [[ -z "${alapkonfig[cidd]}"|| -z "${alapkonfig[cidh]}"|| -z "${alapkonfig[mailhostd]}"|| -z "${alapkonfig[mailhosth]}"|| -z "${alapkonfig[ldapuid]}"|| -z "${alapkonfig[ldapdc]}"\
 || -z "${alapkonfig[ldapuser]}"|| -z "${alapkonfig[zuserh]}"|| -z "${alapkonfig[zuserd]}"|| -z "${alapkonfig[munka]}"|| -z "${alapkonfig[ldapid]}" || -z "$tartomany" ]]
	then echo -e "\n\033[0;31mHiányos vagy sérült\033[0m alapok.cfg!\n"
  exit
 fi
 if ([[ -z "${2// }" ]]) || ([[ ! " ${tartomany[@]} " =~ " ${2} " ]]);then echo -e "\n\033[0;31mAdj meg egy érvényes cél domain-t!\033[0m $2\n"
                                        for tlist in "${tartomany[@]}";do echo -e " - $tlist";done
                                        echo;exit
 fi

echo -e "\nAdatgyűjtés folyamatban...\n"
id=$(cat .idf)

IFS=$'\n'
 while IFS=":" read -r kulcs ertek
  do
 igazitas
  if ! [[ -z "$igazitottkulcs" ]];then
   if [[ $igazitottkulcs == "mailAccept" ]];then mailaccept+=($igazitottertek)
                                            else
                                          ldapadat[$igazitottkulcs]=$igazitottertek
       fi
  fi
done < <(ssh ${alapkonfig[ldapuser]} -T "ldapsearch -LLL -h localhost:389 -D ${alapkonfig[ldapuid]} -w $id -b ${alapkonfig[ldapdc]} ${alapkonfig[ldapid]}=$1"|tr -d '\r')
IFS=$eredetiIFS

 if [[ ${ldapadat[uid]} == "" ]];then echo -e "\n\033[0;31mA megadott azonosító\033[0m $1 \033[0;31mnem található!\033[0m\n";exit;fi

 if [[ $2 = $(echo ${alapkonfig[mailhosth]}|awk -F"[" '{print $2}'|awk -F"]" '{print $1}') ]];then mailhostuj=${alapkonfig[mailhosth]};else mailhostuj=${alapkonfig[mailhostd]};fi
 if [[ "$mailhostuj" == "${alapkonfig[mailhostd]}" ]];then zimbracel=${alapkonfig[zuserd]};cid=${alapkonfig[cidd]};else zimbracel=${alapkonfig[zuserh]};cid=${alapkonfig[cidh]};fi
 if [[ "${ldapadat[mailHost]}" == "${alapkonfig[mailhostd]}" ]];then zimbraforras=${alapkonfig[zuserd]};else zimbraforras=${alapkonfig[zuserh]};fi

IFS=$'\n'
 while IFS=":" read -r kulcs ertek
  do
 igazitas
  if ! [[ -z "$igazitottkulcs" ]];then
   if [[ $igazitottkulcs == "zimbraSharedItem" ]];then
                                                      zsharekivel+=($(echo $igazitottertek|awk -F":" '{print $3}'|awk -F ";" '{print $1}'))
                                                      zsharemit+=($(echo $igazitottertek|awk -F":" '{print $7}'|awk -F ";" '{print $1}'))
                                                      zsharejog+=($(echo $igazitottertek|awk -F":" '{print $9}'|awk -F ";" '{print $1}'))
                                               else
                                                 zimbraadat[$igazitottkulcs]=$igazitottertek
       fi
  fi
done < <(ssh $zimbraforras -T "zmprov ga ${ldapadat[zimbraMailDeliveryAddress]}" 2> /dev/null)
IFS=$eredetiIFS

if [[ -z ${zimbraadat[zimbraAccountStatus]} ]]
	then
		statusold="nincs"
		fiokmeretold=0
		zmid="nincs"
	else
		statusold=${zimbraadat[zimbraAccountStatus]}
		fiokmeretold=($(ssh $zimbraforras zmmailbox -z -m ${ldapadat[zimbraMailDeliveryAddress]} gms -v))
		zmid+=($(ssh $zimbraforras -T "zmprov getidentities ${ldapadat[zimbraMailDeliveryAddress]}|grep zimbraPrefFromAddress:"|awk -F": " '{print $2}'))
fi

echo -e "\n$ver,  $(date)\n\n">>$log
echo "Teljes Név       : "${ldapadat[cn]}|tee -a $log
echo "VezetékNév       : "${ldapadat[sn]}|tee -a $log
echo "KeresztNév       : "${ldapadat[givenName]}|tee -a $log
echo "NEPTUN           : "$1|tee -a $log
echo "UID              : "${ldapadat[uid]}|tee -a $log
echo -e "\nMail most        : "${ldapadat[zimbraMailDeliveryAddress]}|tee -a $log
echo "Host most        : "${ldapadat[mailHost]}|tee -a $log

for malist in "${mailaccept[@]}";do echo "MailAccept       :" $malist|tee -a $log;done
for ((i=0;i<${#zsharekivel[@]};++i));do echo "Megosztások      : ${zsharekivel[$i]} Cél:${zsharemit[$i]} Jog:${zsharejog[$i]}";done
for zm in "${zmid[@]}";do
 if [[ $zm != ${ldapadat[zimbraMailDeliveryAddress]} ]];then echo "Plusz ID         :" $zm|tee -a $log;fi
 done

echo "Méret            : $(echo $fiokmeretold|numfmt --to=iec)"|tee -a $log
echo "Fiók státusz     : "$statusold|tee -a $log
echo "Fiók létrehozás  : "${zimbraadat[zimbraCreateTimestamp]}|tee -a $log
echo "Fiók belépés     : "${zimbraadat[zimbraLastLogonTimestamp]}|tee -a $log

zimbrauj=$(echo ${ldapadat[cn;lang-en]}|sed -e 's/ /./g'|tr '[:upper:]' '[:lower:]')
zsave=$(echo $zimbrauj);zimbrauj=$(echo $zimbrauj@$2);ellenor="!"
 until [[ $ellenor == "" ]];do
      ellenor=$(ssh ${alapkonfig[ldapuser]} -t "ldapsearch -LLL -h localhost:389 -D ${alapkonfig[ldapuid]} -w $id -b ${alapkonfig[ldapdc]} "mail=$zimbrauj""&>/dev/null)
      if [[ $ellenor != "" ]];then let "sor++";zimbrauj=$(echo "$zsave.$sor@$2");fi
 done

if [[ "$zimbrauj" == "${ldapadat[zimbraMailDeliveryAddress]}" ]];then
  echo -e "\nA tartományban a $zimbrauj fiók jelenleg is létezik!\n\n"|tee -a $log;exit
fi
statusuj=$(ssh $zimbracel "zmprov ga "$zimbrauj"|grep zimbraAccountStatus &2>/dev/null");if [[ -z "$statusuj" ]];then statusuj="nincs";else statusuj=$(echo $statusuj|awk -F" " '{print $2}');fi
echo -e "\nÚj Mail          : "$zimbrauj|tee -a $log
echo "Új Host          : "$mailhostuj|tee -a $log
if [[ ! " ${mailaccept[@]} " =~ " ${zimbraold} " ]];then echo "Új MailAccept    :" ${ldapadat[zimbraMailDeliveryAddress]}|tee -a $log;fi
echo "Új Fiók státusz  : "$statusuj|tee -a $log
echo;read -p "Stimmelnek az adatok ? (I/N) " -n 1 -r;echo -e "\n\n"|tee -a $log
if [[ ! $REPLY =~ ^[YyiI]$ ]];then exit;fi

if [[ "$statusuj" == "nincs" ]];then
				printf "Zimbra postafiók $zimbrauj létrehozása..."|tee -a $log
				ssh $zimbracel "zmprov ca $zimbrauj \"\" zimbraCOSid "$cid" displayName \"${ldapadat[cn]}\" givenName \"${ldapadat[sn]}\" sn \"${ldapadat[givenName]}\"">> $log
				 if [[ ! -z ${zimbraadat[zimbraPrefSkin]} ]];then ssh $zimbracel "zmprov ma $zimbrauj zimbraPrefSkin ${zimbraadat[zimbraPrefSkin]}";fi
fi
if [[ "$statusuj" == "closed" ]];then
                                printf "Zimbra postafiók $zimbrauj újraaktiválása.."|tee -a $log
                                ssh $zimbracel "zmprov ma $zimbrauj zimbraAccountStatus active"
fi
if [[ "$statusuj" == "active" ]];then printf "Zimbra postafiók $zimbrauj jelenleg is akív"|tee -a $log;fi

if [[ $fiokmeretold -ge $(ssh $zimbracel "zmprov ga $zimbrauj|grep zimbraMailQuota|grep -oE '[0-9]+'") ]];then ssh $zimbracel "zmprov ma $zimbrauj zimbraMailQuota $(($fiokmeretold+1073741824))";fi

echo -e "Kész.\n\nLDAP módosítása...\n"|tee -a $log

if [[ "$statusold" == "nincs" ]]
  then
    echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nadd:objectClass\nobjectClass:ppkeMail"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
    echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nadd:objectClass\nobjectClass:zimbraMailRecipient"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
  else
   echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nadd:mailAccept\nmailAccept:${ldapadat[zimbraMailDeliveryAddress]}"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
    if [[ " ${mailaccept[@]} " =~ " $zimbrauj " ]];then
       echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\ndelete:mailAccept\nmailAccept:$zimbrauj"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
    fi
fi

if [[ "$mailhostuj" != "${ldapadat[mailHost]}" ]];then
    echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nreplace:mailHost\nmailHost:$mailhostuj"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
fi

echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nreplace:zimbraMailDeliveryAddress\nzimbraMailDeliveryAddress:$zimbrauj"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
echo -e "dn: uid=${ldapadat[uid]},ou=people,${alapkonfig[ldapdc]}\nchangetype:modify\nreplace:mail\nmail:$zimbrauj"|ssh ${alapkonfig[ldapuser]} -T "ldapmodify -v -h localhost:389 -x -D ${alapkonfig[ldapuid]} -w $id"|tee -a $log
echo -e "Kész\n"

if [[ "$statusold" != "nincs" ]];then
   ssh $zimbraforras "zmprov ma ${ldapadat[zimbraMailDeliveryAddress]} zimbraAccountStatus closed";echo "Postafiók ${ldapadat[zimbraMailDeliveryAddress]} bezárva."|tee -a $log
   echo "Postafiók ${ldapadat[zimbraMailDeliveryAddress]} mentése folyamatban..."|tee -a $log
   ssh $zimbraforras -T "zmmailbox -z -m ${ldapadat[zimbraMailDeliveryAddress]} gru \"//?fmt=tgz\" >${alapkonfig[munka]}/$1.tgz"
   ssh $zimbraforras -T "zmprov ga ${ldapadat[zimbraMailDeliveryAddress]} zimbraMailSieveScript >${alapkonfig[munka]}/$1.szuro.be;zmprov ga ${ldapadat[zimbraMailDeliveryAddress]} zimbraMailOutgoingSieveScript >${alapkonfig[munka]}/$1.szuro.ki"
   ssh $zimbraforras -T "tail -n +2 ${alapkonfig[munka]}/$1.szuro.be|sed -e \"s/zimbraMailSieveScript: //g\" >${alapkonfig[munka]}/$1.szuro.be.tmp;mv -f ${alapkonfig[munka]}/$1.szuro.be.tmp ${alapkonfig[munka]}/$1.szuro.be"
   ssh $zimbraforras -T "tail -n +2 ${alapkonfig[munka]}/$1.szuro.ki|sed -e \"s/zimbraMailOutgoingSieveScript: //g\" >${alapkonfig[munka]}/$1.szuro.ki.tmp;mv -f ${alapkonfig[munka]}/$1.szuro.ki.tmp ${alapkonfig[munka]}/$1.szuro.ki"
   ssh $zimbraforras -T "zmprov gsig ${ldapadat[zimbraMailDeliveryAddress]}>${alapkonfig[munka]}/$1.alairasok"
    if [[ "$mailhostuj" != "${ldapadat[mailHost]}" ]];then
      ssh $zimbraforras -T  "rsync -a --remove-source-files ${alapkonfig[munka]}/$1.* $zimbracel:${alapkonfig[munka]}"
    fi
    if [[ "$mailhostuj" == "${ldapadat[mailHost]}" ]];then
  	ssh $zimbraforras "zmprov da ${ldapadat[zimbraMailDeliveryAddress]}"
	echo "Postafiók ${ldapadat[zimbraMailDeliveryAddress]} törölve. "|tee -a $log
    fi
 echo
 for zid in "${zmid[@]}"
  do
   if [[ $zid != $zimbrauj ]];then
    ssh $zimbracel -T "zmprov ma $zimbrauj +zimbraAllowFromAddress $zid;zmprov createIdentity $zimbrauj \"$zid\" zimbraPrefFromAddress \"$zid\" zimbraPrefFromDisplay \"$zid\" zimbraPrefWhenSentToEnabled FALSE"
    echo "Postafiók $zimbrauj számára $zid nevében való üzenetküldés beállítva."|tee -a $log
   fi
 done

 echo;printf "Elkészült, migrálás..."|tee -a $log
 ssh $zimbracel -T "zmmailbox -z -m $zimbrauj postRestURL \"//?fmt=tgz&resolve=skip\" ${alapkonfig[munka]}/$1.tgz"
 ssh $zimbracel bash -c "'SIEVEVAR=\`cat ${alapkonfig[munka]}/$1.szuro.be\`;zmprov ma $zimbrauj zimbraMailSieveScript \"\$SIEVEVAR\"'"
 ssh $zimbracel bash -c "'SIEVEVAR=\`cat ${alapkonfig[munka]}/$1.szuro.ki\`;zmprov ma $zimbrauj zimbraMailOutgoingSieveScript \"\$SIEVEVAR\"'"
 ssh $zimbracel -T "csplit -s -f ${alapkonfig[munka]}/$1- -z ${alapkonfig[munka]}/$1.alairasok /\#/ '{*}'''";alairaslista+=($(ssh $zimbracel "ls ${alapkonfig[munka]}/$1-[0-9]* 2> /dev/null"))

 for ((i=0;i<${#zsharekivel[@]};++i))
 do
  ssh $zimbracel -T "zmmailbox -z -m \"$zimbrauj\" mfg \"${zsharemit[$i]}\" account \"${zsharekivel[$i]}\" ${zsharejog[$i]} &>/dev/null"
  ssh $zimbracel -T "zmmailbox -z -m \"${zsharekivel[$i]}\" cm -c red \"${zsharemit[$i]}\" \"$zimbrauj\" \"${zsharemit[$i]}\" &>/dev/null"
  echo -e "\nPostafiók $zimbrauj számára megosztások migrálása: Kivel:${zsharekivel[$i]} Mit:${zsharemit[$i]} Jogosultság:${zsharejog[$i]}"|tee -a $log
 done

 for alist in "${alairaslista[@]}"
        do
         while IFS='' read -r line||[[ -n "$line" ]];do
         if [[ $line == \#* ]];then alairasnev=$(echo "$line"|awk -F" " '{print $3}');fi
          if [[ $line == zimbraPrefMailSignature* ]]
						then alairastipus=$(echo $line|awk -F":" '{print $1}')
						echo $line|awk -F":" '{print $2}'|sed 's/ //'|ssh $zimbracel -T "cat > ${alapkonfig[munka]}/$1.alairas"
	  fi
         if ! [[ $line == \#* || $line == zimbra* ]];then echo $line|ssh $zimbracel -T "cat >> ${alapkonfig[munka]}/$1.alairas";fi
	done < <(ssh -n $zimbracel "cat $alist 2> /dev/null")
	ssh $zimbracel bash -c "SIGVAR=;SIGVAR=\`cat ${alapkonfig[munka]}/$1.alairas\`;zmprov csig $zimbrauj \"$alairasnev\" $alairastipus \"\$SIGVAR\">/dev/null 2> /dev/null"
 done
fi

ssh $zimbracel -T "rm -f ${alapkonfig[munka]}/$1.*"

if [[ $zimbracel == ${alapkonfig[zuserd]} ]];then ssh $zimbracel bash -T "ppke_alairas_install -e $zimbrauj $2" |tee -a $log;fi

echo -e "Kész\n"|tee -a $log
date>>$log
