#!/bin/bash
#Created By F.E.K.
#zimbra központi aláírás install
#2021.06.29

declare -A alapkonfig
unset listafile;unset celtartomany
linksablonok="ppke facebook instagram linkedin youtube blog logo"

if [ "$(id -un)x" != "zimbrax" ];then echo "Zimbra felhasználóként futtasd!";exit;fi
if [ ! -f /usr/share/ppke_alairas_deploy/alairas.cfg ];then echo -e "\n\033[0;31m/usr/share/ppke_alairas_deploy/alairas.cfg nem található!\033[0m\n";exit;fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
}

ellenor () {
 if ([[ ! " ${tartomany[@]} " =~ " $(echo $postafiok|awk -F "@" {'print $2'}) " ]] || [[ ! $(zmaccts|grep active|grep @|awk '{print $1}'|grep $postafiok$) ]]);then
    echo -e "\n\033[0;31mÉrvénytelen cím! ($postafiok)\033[0m"|tee -a $log
    sugo
  fi
}

sugo () {
 echo -e "\nKötelező EGY paraméter a lentiek közül:\n\n -e emailcím céltartomány \n\n -l listafile [céltartomány] \n\n -d emailcím [törlendő_aláírásnév] \n\n vagy\n\n -t tartomány [céltartomány] (a lenti listából):\n"
 for tlist in "${tartomany[@]}";do echo -e "  $tlist";done
 echo -e "\nTöbb opció megadása esetén az elsőként megadott lesz feldolgozva\n"
 echo -e "Listafile, tartomány esetén a tartomány megadása opcionális, amennyiben nincs megadva az alapérték a 'tartomány'-ként megadott paraméter\n"
 echo -e "Meglévő aláírás törlése a -d opcióval lehetséges, hiányzó aláírásnév paraméter esetén a címhez tartozó aláírás nevek kerülnek listázásra.\n"
 exit
}

lefutott () {
 echo -e "\nLefutott: $(date)\n"|tee -a $log
 exit
}

alairastelepites () {
 ellenor
 echo "Aláírás telepítése: $postafiok"|tee -a $log
 linkcel=$(echo $sabloncel|cut -f1 -d '.')
  for kepek in "${alapkonfig[grafikak]}"/*
    do
    if [[ ! $kepek == *"logo_"* ]] || [[ $kepek == *"logo_$linkcel."* ]];then
	if [[ $(zmmailbox -z -m $postafiok s -t doc "in:briefcase ${kepek##*/}"|grep ${kepek##*/}|awk {'print $2'}) ]];then
	    echo "Grafikai elem ${kepek##*/} már létezik, frissítés..."|tee -a $log
            zmmailbox -z -m $postafiok di $(zmmailbox -z -m $postafiok s -t doc "in:briefcase ${kepek##*/}"|grep ${kepek##*/}|awk {'print $2'})
	fi
	zmmailbox -z -m $postafiok postRestURL --contentType image/${kepek##*.} /Briefcase/$(echo ${kepek##*/}) $kepek|echo "Grafikai elem feltöltve: ${kepek##*/}"|tee -a $log
    fi
    done
 for szoveg in "${alapkonfig[torzsek]}"/*
    do
     if [[ ! $szoveg == *"alairas_"* ]] || [[ $szoveg == *"$szoveg_$linkcel."* ]];then
       SIGVAR=;SIGVAR=`cat $szoveg`;SIGVAR=${SIGVAR//${alapkonfig[cimsablon]}/$postafiok}
	for e in $linksablonok
	    do
		if [ -z ${alapkonfig[${linkcel}_${e}]} ];then
		    SIGVAR=${SIGVAR//${alapkonfig[linksablon_${e}]}/${alapkonfig[ppke_${e}]}}
		else
		    SIGVAR=${SIGVAR//${alapkonfig[linksablon_${e}]}/${alapkonfig[${linkcel}_${e}]}}
		fi
	    done
     alairasnev=$((echo ${szoveg##*/})|cut -f 1 -d '.')
	if [[ $(zmprov gsig $postafiok|grep name|cut -f 3 -d ' '|grep "$alairasnev$") ]];then
	    echo "Aláírás $alairasnev már létezik, kihagyva..."|tee -a $log
##	    zmprov dsig $postafiok $alairasnev
	    else
	    echo "Aláírás $alairasnev telepítése..."|tee -a $log
	    zmprov csig $postafiok "$alairasnev" zimbraPrefMailSignatureHTML "$SIGVAR"|tee -a $log
	fi
     fi
    done
 echo -e "Kész\n"|tee -a $log
}

alairastorles () {
 ellenor
 echo -e "\nVer: ${alapkonfig[verzio]}, Megadott postafiók: $postafiok, törlendő aláírás: $alairascel, Indítva: $(date)\n"|tee -a $log
 if [[ $alairascel ]];then
    zmprov dsig $postafiok $alairascel
    else
    echo -e "\nJelenlegi aláírások:\n"
    zmprov gsig $postafiok|grep name|sed -e 's/# name //'|tee -a $log
 fi
 echo -e "\n"
}

listabol () {
 echo -e "\nVer: ${alapkonfig[verzio]}, Megadott lista file: $listafile, Indítva: $(date)\n"|tee -a $log
 if [ ! -f $listafile ];then echo -e "\nA megadott $listafile nem található!\n"|tee -a $log;exit;fi
 while IFS='' read -r postafiok||[[ -n "$postafiok" ]];do
    if [ ! -z "$postafiok" ];then alairastelepites;fi
 done <$listafile
}

tartomanybol () {
 echo -e "\nVer: ${alapkonfig[verzio]}, Megadott tartomány: $celtartomany, Indítva: $(date)\n"|tee -a $log
 postafiokok+=$(zmaccts|grep active|grep @$celtartomany|grep -v 'galsync\|restore\|spam\|gmail'|awk '{print $1}')
 SAVEIFS=$IFS;IFS=$'\n';postafiokok=($postafiokok);IFS=$SAVEIFS
 for postafiok in ${postafiokok[@]}
   do
    alairastelepites
   done
}

email () {
 echo -e "\nVer: ${alapkonfig[verzio]}, Megadott postafiók: $postafiok, Indítva: $(date)\n"|tee -a $log
 alairastelepites
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
  if [[ $igazitottkulcs == "tartomany" ]];then tartomany+=($igazitottertek)
                                        else
                                        if ! [[ -z "$igazitottkulcs" ]];then alapkonfig[$igazitottkulcs]=$igazitottertek;fi
 fi
done < /usr/share/ppke_alairas_deploy/alairas.cfg

if [[ -z "${alapkonfig[verzio]}"||
      -z "${alapkonfig[grafikak]}"||
      -z "${alapkonfig[torzsek]}"||
      -z "${alapkonfig[cimsablon]}"||
      -z "$tartomany"||
      -z "${alapkonfig[linksablon_facebook]}"||
      -z "${alapkonfig[linksablon_instagram]}"||
      -z "${alapkonfig[linksablon_linkedin]}"||
      -z "${alapkonfig[linksablon_blog]}"||
      -z "${alapkonfig[linksablon_youtube]}"||
      -z "${alapkonfig[linksablon_ppke]}"||
      -z "${alapkonfig[linksablon_logo]}"||
      -z "${alapkonfig[logfile]}" ]]
        then echo -e "\n\033[0;31mHiányos, sérült vagy nem olvasható\033[0m alairas.cfg!\n"
  exit
fi

 if [ ! -d ${alapkonfig[grafikak]} ];then echo -e "\n\033[0;31m${alapkonfig[grafikak]} mappa nem található!\033[0m\n";exit;fi
 if [ ! -d ${alapkonfig[torzsek]} ];then echo -e "\n\033[0;31m${alapkonfig[torzsek]} mappa nem található!\033[0m\n";exit;fi

log=${alapkonfig[logfile]}`date +"%Y-%m-%d_%H-%M"`_alairas.log

 if [[ -z "$3" ]] || [[ $1 == "-d" ]]
    then sabloncel=$2
    else
	if ([[ ! " ${tartomany[@]} " =~ " ${3} " ]]);then
	    echo -e "\n\033[0;31mÉrvénytelen domain! ($3)\033[0m"
	    sugo
	fi
    sabloncel=$3
 fi

while getopts ":l:t:e:d:" kapcsolo
do
    case "${kapcsolo}" in
       l) listafile=${OPTARG}
	    listabol
	    lefutott
	;;
        t) celtartomany=${OPTARG}
	    if ([[ ! " ${tartomany[@]} " =~ " ${celtartomany} " ]])
		then echo -e "\n\033[0;31mÉrvénytelen tartomány! ($celtartomany)\033[0m"
		sugo
            fi
	    tartomanybol
	    lefutott
	;;
	e) postafiok=${OPTARG}
	   if [[ -z "$3" ]];then "Hiányzó céltartomány!";sugo;fi
	    email
	    lefutott
	;;
	d) postafiok=${OPTARG}
	    alairascel=$3
	    alairastorles
	    lefutott
	;;
	?) echo -e "\n\033[0;31mIsmeretlen / hiányos opció:\033[0m \"-$OPTARG\""
	    sugo
	;;
    esac
done

if [[ -z "$listafile" && -z "$celtartomany" && -z "$postafiok" ]];then sugo;fi
