#!/bin/bash
#Created By F.E.K.
#2019.10.18

ver=V1.2
log=mail-report_$1_$(date +%F-%H-%M).log
declare -A alapkonfig
declare -A ldapadat
declare -A zimbraadat
eredetiIFS=$IFS
sorszam=1
feldolgozas="maintance"

 if [ ! -f alapok.cfg ];then echo -e "\n\033[0;31mAlapok.cfg nem található!\033[0m\n";exit;fi
 if [ ! -f .idf ];then echo -e "\n\033[0;31mIDF állomány nem található!\033[0m\n";exit;fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
  if [[ $igazitottertek = :* ]];then igazitottertek=$(echo $igazitottertek|awk -F " " '{print $2}'|base64 --decode 2>&1);fi
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
  if [[ $igazitottkulcs == "tartomany" ]];then tartomany+=($igazitottertek)
                                        else
                                        if ! [[ -z "$igazitottkulcs" ]];then alapkonfig[$igazitottkulcs]=$igazitottertek;fi
fi
done < alapok.cfg

 if [[ -z "${alapkonfig[mailhostd]}"|| -z "${alapkonfig[ldapuid]}"|| -z "${alapkonfig[ldapdc]}" || -z "${alapkonfig[ldapuser]}"|| -z "${alapkonfig[zuserd]}"|| -z "${alapkonfig[ldapid]}" ]]
	then echo -e "\n\033[0;31mHiányos vagy sérült\033[0m alapok.cfg!\n"
  exit
 fi

 if [ -z "$" ] || [ "$1" != "aktiv" ] && [ "$1" != "bezart" ] && [ "$1" != "zarolt" ] && [ "$1" != "fuggo" ] && [ "$1" != "karbantartas" ] && [ "$1" != "mind" ]
  then
   echo -e "\nParaméter hibás vagy hiányzik!\n\n     - \033[0;31m(kötelező)\033[0m paraméter: feldolgozandó típus (aktiv, bezart, zarolt, fuggo, karbantartas, mind)\n"
   exit
 fi

 if [ "$1" == "aktiv" ];then feldolgozas="active";fi
 if [ "$1" == "bezart" ];then feldolgozas="closed";fi
 if [ "$1" == "zarolt" ];then feldolgozas="locked";fi
 if [ "$1" == "fuggo" ];then feldolgozas="pending";fi
 if [ "$1" == "mind" ]
    then
     fiokok+=($(ssh ${alapkonfig[zuserd]} "zmprov -l gaa"|grep -v "galsync\|spam"))
    else
     fiokok+=($(ssh ${alapkonfig[zuserd]} "zmprov -l sa \"(zimbraAccountStatus=$feldolgozas)\""|grep -v "galsync\|spam"))
 fi

id=$(cat .idf)

echo -e "\nIndítva: $ver,  $(date), szures: $1"|tee $log

#main start
for fiok in "${fiokok[@]}"
  do
  unset zsharekivel;unset zsharemit;unset zsharejog;unset zmid;unset mailaccept;ldapadat[uid]=""
   IFS=$'\n'
    while IFS=":" read -r kulcs ertek
     do
      igazitas
       if ! [[ -z "$igazitottkulcs" ]]
        then
          if [[ $igazitottkulcs == "mailAccept" ]]
            then
              mailaccept+=($igazitottertek)
           else
              ldapadat[$igazitottkulcs]=$igazitottertek
          fi
       fi
     done < <(ssh ${alapkonfig[ldapuser]} -n "ldapsearch -LLL -h localhost:389 -D ${alapkonfig[ldapuid]} -w $id -b ${alapkonfig[ldapdc]} ${alapkonfig[ldapid]}=$fiok"|tr -d '\r')
 IFS=$eredetiIFS

  if [[ ${ldapadat[uid]} == "" ]]
     then
      echo -e "\n----------------------------------------------------------"|tee -a $log
      echo -e "Fiók             : ${#fiokok[@]}/$sorszam\n"|tee -a $log
      echo "A megadott azonosító: $fiok nem ppke fiók."|tee -a $log
     else
 IFS=$'\n'
  while IFS=":" read -r kulcs ertek
   do
    igazitas
     if ! [[ -z "$igazitottkulcs" ]]
       then
        if [[ $igazitottkulcs == "zimbraSharedItem" ]]
           then
            zsharekivel+=($(echo $igazitottertek|awk -F":" '{print $3}'|awk -F ";" '{print $1}'))
            zsharemit+=($(echo $igazitottertek|awk -F":" '{print $7}'|awk -F ";" '{print $1}'))
            zsharejog+=($(echo $igazitottertek|awk -F":" '{print $9}'|awk -F ";" '{print $1}'))
           else
            zimbraadat[$igazitottkulcs]=$igazitottertek
       fi
    fi
  done < <(ssh -n ${alapkonfig[zuserd]} -T "zmprov ga ${ldapadat[zimbraMailDeliveryAddress]}")
 IFS=$eredetiIFS
 fiokmeret=($(ssh -n ${alapkonfig[zuserd]} zmmailbox -z -m ${ldapadat[zimbraMailDeliveryAddress]} gms -v))
 zmid+=($(ssh -n ${alapkonfig[zuserd]} -T "zmprov getidentities ${ldapadat[zimbraMailDeliveryAddress]}|grep zimbraPrefFromAddress:"|awk -F": " '{print $2}'))
 echo -e "\n----------------------------------------------------------"|tee -a $log
 echo -e "Fiók             : ${#fiokok[@]}/$sorszam\n"|tee -a $log
 echo "Teljes Név       : "${ldapadat[cn]}|tee -a $log
 echo "VezetékNév       : "${ldapadat[sn]}|tee -a $log
 echo "KeresztNév       : "${ldapadat[givenName]}|tee -a $log
 echo "NEPTUN           : "${ldapadat[ppkePersonOrgID]}|tee -a $log
 echo "UID              : "${ldapadat[uid]}|tee -a $log
 echo -e "\nMail             : "${ldapadat[zimbraMailDeliveryAddress]}|tee -a $log
 echo "Host             : "${ldapadat[mailHost]}|tee -a $log
  for malist in "${mailaccept[@]}"
    do
     echo "MailAccept       :" $malist|tee -a $log
    done
  for ((i=0;i<${#zsharekivel[@]};++i))
   do
    echo "Megosztások      : ${zsharekivel[$i]} Cél:${zsharemit[$i]} Jog:${zsharejog[$i]}"|tee -a $log
   done
  for zm in "${zmid[@]}"
    do
     if [[ $zm != ${ldapadat[zimbraMailDeliveryAddress]} ]];then echo "Plusz ID         :" $zm|tee -a $log;fi
  done
 echo "Méret            : $(echo $fiokmeret|numfmt --to=iec)"|tee -a $log
 echo "Fiók státusz     : "${zimbraadat[zimbraAccountStatus]}|tee -a $log
 echo "Fiók létrehozás  : "${zimbraadat[zimbraCreateTimestamp]}|tee -a $log
 echo "Fiók belépés     : "${zimbraadat[zimbraLastLogonTimestamp]}|tee -a $log
 fi
 let "sorszam++"
done

#main end
echo -e "\n----------------------------------------------------------"|tee -a $log
echo -e "\nLefutott: $(date)\n"|tee -a $log
