#!/bin/bash
#Created By F.E.K.
#simple cert check
#2025.04.24

conf=certellenor.conf
export PATH="/usr/bin"

declare -A certconf
 if [ ! -f $conf ];then echo -e "\n\033[0;31m$conf nem található!\033[0m\n";exit;fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo ${ertek,,}|sed -e 's/^[ \t]*//')
  if [[ $igazitottertek = :* ]];then igazitottertek=$(echo $igazitottertek|awk -F " " '{print $2}'|base64 --decode 2>&1);fi
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
  if [[ $igazitottkulcs == "tartomany" ]];then tartomany+=($igazitottertek)
                                          else
                                           if ! [[ -z "$igazitottkulcs" ]];then certconf[$igazitottkulcs]=$igazitottertek;fi
fi
done < $conf

 if [[ -z "${certconf[ver]}"|| -z "${certconf[loghelye]}"|| -z "${certconf[logmaxmeret]}"|| -z "${certconf[mailkuldes]}"|| -z "${certconf[mreport]}" \
	|| -z "${certconf[mail]}" || -z "${certconf[mailtargy]}" || -z "${certconf[idotartam]}" || -z "$tartomany" ]]
     then echo -e "\n\033[0;31mHiányos vagy sérült\033[0m $conf!\n"
     exit
 fi

 if (( $(stat -c%s "${certconf[loghelye]}") > ${certconf[logmaxmeret]} ));then tar --remove-files --overwrite -czf ${certconf[loghelye]}.tgz ${certconf[loghelye]};fi

echo -e "Cert időszak figyelmeztetés!" > ${certconf[mreport]}
echo -e "\n--- $(basename $BASH_SOURCE) -- V${certconf[ver]} by F.E.K. ---\nIndítva:  $(date)\nVizsgált érvényességi időtartam: $(printf '%d nap\n' $((${certconf[idotartam]}/86400)))\n"|tee -a ${certconf[loghelye]} ${certconf[mreport]}
for tlist in "${tartomany[@]}"
 do
  echo -e "\nVizsgálva: $tlist"|tee -a ${certconf[loghelye]}
  eredmeny=$(openssl s_client -connect $tlist:443 </dev/null 2>/dev/null | openssl x509 -noout  -enddate -checkend ${certconf[idotartam]}|| echo "_= Nem elérhető host!")
   if [[ $eredmeny != *"Certificate will not expire"* ]]
	then
	 echo -e "$tlist - Lejár, Érvényesség: $(echo $eredmeny|awk -F'Certificate' '{print $1}'|awk -F'=' '{print $2}')"|tee -a ${certconf[loghelye]} ${certconf[mreport]}
  fi
done

echo -e "\nLefutott:  $(date)"|tee -a ${certconf[loghelye]} ${certconf[mreport]}

if grep -q Lejár "${certconf[mreport]}";then
	 if [ ${certconf[mailkuldes]} == "igen" ];then mail -a "Content-Type: text/plain; charset=UTF-8" -s "${certconf[mailtargy]}" ${certconf[mail]} < "${certconf[mreport]}" 2>/dev/null;fi
fi
