#!/bin/bash

#Created By F.E.K.
#2022.09.12
#worker - mento

declare -A backuperkonfig
munkahely="/local_backup/worker"

 if [ ! -f $munkahely/backuper.cfg ]
    then echo -e "backuper.cfg nem található!\n"|tee $munkahely/statusmail
     mail -a "Content-Type: text/plain; charset=UTF-8" -s "menhely_sync_hiba" root < $munkahely/statusmail
     exit
 fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
   [[ $igazitottkulcs =~ ^#.* ]] && continue
   if [[ $igazitottkulcs == "celpont" ]];then celmappak+=($igazitottertek)
                                        else
                                        if ! [[ -z "$igazitottkulcs" ]];then backuperkonfig[$igazitottkulcs]=$igazitottertek;fi
fi
done < $munkahely/backuper.cfg

 if [[ -z "${backuperkonfig[ver]}"|| -z "${backuperkonfig[sig]}"|| -z "${backuperkonfig[loghely]}"|| -z ${backuperkonfig[valtozat]}|| -z "${backuperkonfig[backuphely]}"\
 || -z "${backuperkonfig[forras]}"|| -z ${backuperkonfig[logidoszak]}|| -z "${backuperkonfig[mail]}"||-z "${backuperkonfig[dbuser]}"||-z "${backuperkonfig[dbpw]}"|| -z "${backuperkonfig[db_backuphely]}" ]]
    then
    echo -e "Hiányos vagy sérült alapok.cfg!\n"|tee $munkahely/statusmail
    mail -a "Content-Type: text/plain; charset=UTF-8" -s "menhely_sync_hiba" root < $munkahely/statusmail
    exit
 fi

log=${backuperkonfig[loghely]}/menhely_$(date +%F-%H-%M).log

 if mount |grep -n "${backuperkonfig[sig]}\>" > /dev/null
    then
     echo -e "\nIndítva: V${backuperkonfig[ver]},  $(date), Worker oldal\n" > $log
      for sorszam in $(seq ${backuperkonfig[valtozat]} -1 -0 )
       do
        if [[ $sorszam == ${backuperkonfig[valtozat]} ]]
          then
           [ ! -d "${backuperkonfig[backuphely]}/_$sorszam" ] && mkdir ${backuperkonfig[backuphely]}/_$sorszam
            mv ${backuperkonfig[backuphely]}/_$sorszam ${backuperkonfig[backuphely]}/_0
          else
            mv ${backuperkonfig[backuphely]}/_$sorszam ${backuperkonfig[backuphely]}/_$(($sorszam+1))
        fi
       done
        rsync -vrthlz --mkpath --progress --delete ${backuperkonfig[forras]} ${backuperkonfig[backuphely]}/_1 >> $log
        head -n 3 $log > $munkahely/statusmail
        echo -e "\nDB check: - $(ls -t ${backuperkonfig[backuphely]}/_1/${backuperkonfig[db_backuphely]}/* | head -1|awk -F "." '{print $1}'|awk -F "/" '{print $NF}') -" >> $munkahely/statusmail
        tar -zxf $(ls -t ${backuperkonfig[backuphely]}/_1/${backuperkonfig[db_backuphely]}/* | head -1) --strip-components=3 -C ${backuperkonfig[backuphely]}
        cat $(ls -t ${backuperkonfig[backuphely]}/*.sql) | mysql --user=${backuperkonfig[dbuser]} --password=${backuperkonfig[dbpw]} |tee -a $munkahely/statusmail
        rm -f $(ls -t ${backuperkonfig[backuphely]}/*.sql | head -1)
        echo -e "\nLefutott, $(date)\n" >> $log
        tail -n 6 $log >> $munkahely/statusmail
        tar --remove-files -I pigz -cvpf $log.tgz $log
    else
    echo -e "\nInditva V${backuperkonfig[ver]},  $(date), Worker oldal\nNincs feloldva!\n"|tee $munkahely/statusmail
 fi

mail -a "Content-Type: text/plain; charset=UTF-8" -s "menhely_sync" ${backuperkonfig[mail]} < statusmail 2>/dev/null

sleep 1
find ${backuperkonfig[loghely]}/*.tgz -mtime +${backuperkonfig[logidoszak]} -exec rm {} \;
