#!/usr/bin/perl
#neptun jelszó alapján való jelszóváltás - debug és teszt
#V1.0
#Created By F.E.K.

use strict;
use warnings;
use Net::LDAP;
use Data::Dumper;
use Encode qw( encode_utf8 );
use HTTP::Request ();
use LWP::UserAgent;
use JSON;
use utf8;
use Term::ReadKey;
use Config::General;

my $conf = Config::General->new(
    -ConfigFile => 'alapok.cfg',
    -InterPolateVars => 1
);

my %config = $conf->getall;

my $ldapserver = $config{'ldap_adatok'}{'ldapserver'};
my $basedn = $config{'ldap_adatok'}{'basedn'};
my $neptuncim = $config{'neptun_adatok'}{'webapi_cim'};
my $neptunlogin = $config{'neptun_adatok'}{'neptunlogin_cim'};
my $dolgozo = $config{'neptun_adatok'}{'dolgozoi_adat'};
my $hallgato = $config{'neptun_adatok'}{'hallgatoi_adat'};

sub ldapkeres {
my $user = shift;my $msg;my $entry;
my $ldap = Net::LDAP->new($ldapserver) or die "ldap szerverkapcsolat sikertelen!\n";
$msg = $ldap->search(
                base => $basedn,
                scope => "sub",
                filter => "(ppkePersonOrgID=$user)"
                );
$entry = $msg->entry(0);
my $uid = eval { $entry->get_value( 'uid' ) };
$uid or $uid = "ismeretlen";
$msg = $ldap->unbind;
return ($uid);
}

sub lekerdez_neptun {
my $cel = shift;my $neptunc = shift;
my $url = ($neptuncim . $cel . '');
my $fejlec = ['Content-Type' => 'application/json; charset=UTF-8'];
my $leker = HTTP::Request->new('POST', $url, $fejlec, (encode_utf8(qq/{"NeptunKod": ["$neptunc/.qq/"]}/)));

my $eredmeny = (LWP::UserAgent->new())->request($leker);
return decode_json($eredmeny->decoded_content);
}

sub neptunpw {
 my $nuser = shift;my $nupw = shift;
 my $fejlec = ['Content-Type' => 'application/json; charset=UTF-8'];
 my $data = '{"FelhasznaloNev": "'.$nuser.'", "Jelszo": "'.$nupw.'"}';
 my $encoded_data = encode_utf8($data);
 my $leker = HTTP::Request->new('POST', $neptunlogin, $fejlec, $encoded_data);

 my $eredmeny = (LWP::UserAgent->new())->request($leker);

#Csúnya hack by fekis1 - ha kérdik' letagadom ;)
#print Dumper($eredmeny);
my $abc = Dumper($eredmeny);

if ((index($abc, "rendelve!") != -1) or (index($abc, "SessionId")) != -1) {
    return ("OK");
     } else {
    return ("Téves");
    }
}

sub uidchecker {
my $shibd = shift;
my $uid = shift;
 if ($shibd eq $uid) {
 return ("Egyezik");
 } else {
 return ("Nem egyezik");
}
}

#main start
my $neptunkod;my $shibd;my $npw;

print encode_utf8 "\nNeptun kód?    : ";
chomp ($neptunkod = <>);
print "Shibboleth Id? : ";
chomp ($shibd = <>);
print "Neptun pw?     : ";

Term::ReadKey::ReadMode('noecho');
$npw = Term::ReadKey::ReadLine(0);
Term::ReadKey::ReadMode('restore');
print "\n";
$npw =~ s/\R\z//;

my $npwstatus = neptunpw ($neptunkod,$npw);
my $uid = ldapkeres ($neptunkod);
my $text = lekerdez_neptun ($dolgozo,$neptunkod);

my $neptuneredmeny = eval { encode_utf8($text->{'AlkalmazottiAdat'}->[0]->{'NeptunKod'}) };
  $neptuneredmeny or $neptuneredmeny = "ismeretlen";

if (!$neptuneredmeny) {
    my $text = lekerdez_neptun ($hallgato,$neptunkod);
    my $neptuneredmeny = eval { encode_utf8($text->{'OktatasiAdat'}->[0]->{'Kod'}) };
    $neptuneredmeny or $neptuneredmeny = "ismeretlen";
    }

my $neputnuid = uidchecker ($shibd,$uid);

print encode_utf8 "\n\nMegadott Nepun kód      : ".$neptunkod."\n";
print encode_utf8 "Megadott jelszó állapot : ".$npwstatus."\n";
print encode_utf8 "Megadott UID            : ".$shibd."\n";
print encode_utf8 "Neptunhoz rendelt UID   : ".$uid." = ".$neputnuid."\n\n";

#innen átveheti a jelszóváltás rész