#!/usr/bin/env perl
#Created By F.E.K.
#V1.0
#Neptun interface teszt

use strict;
use warnings;
use Encode qw( encode_utf8 );
use HTTP::Request ();
use LWP::UserAgent;
use JSON;
use Data::Dumper;
use utf8;
use Config::General;

my $conf = Config::General->new(
    -ConfigFile => 'alapok.cfg',
    -InterPolateVars => 1
);

my %config = $conf->getall;

my $neptuncim = $config{'neptun_adatok'}{'webapi_cim'};
my $dolgozo = $config{'neptun_adatok'}{'dolgozoi_adat'};
my $hallgato = $config{'neptun_adatok'}{'hallgatoi_adat'};
my $szemelyi = $config{'neptun_adatok'}{'szemelyi_adatok'};
my $status = $config{'neptun_adatok'}{'statusz_adatok'};

sub lekerdez {
my $cel = shift;
my $url = ($neptuncim . $cel . '');

my $fejlec = ['Content-Type' => 'application/json; charset=UTF-8'];
my $leker = HTTP::Request->new('POST', $url, $fejlec, (encode_utf8(qq/{"NeptunKod": ["$ARGV[0]/.qq/"]}/)));
my $eredmeny = (LWP::UserAgent->new())->request($leker);

return (decode_json($eredmeny->decoded_content));
}

if (not defined $ARGV[0]) {
  die "Neptun kód paraméter szükséges\n";
}

my $text = lekerdez ($dolgozo);
print Dumper($text);

$text = lekerdez ($hallgato);
print Dumper($text);

$text = lekerdez ($szemelyi);
print Dumper($text);

$text = lekerdez ($status);
print Dumper($text);
