#!/usr/bin/perl
#Created by F.E.K.
#2020.08.02

use strict;
use warnings;
use Net::LDAP;
use CGI ':standard';
use JSON;
use Config::General;

my $conf = Config::General->new(
    -ConfigFile => 'alapok.cfg',
    -InterPolateVars => 1
);

my %config = $conf->getall;

my $ldapserver = $config{'ldap_adatok'}{'ldapserver'};
my $basedn = $config{'ldap_adatok'}{'basedn'};

sub ldapkeres {
my $neptun = shift;
my $msg;
my $entry;

my $ldap = Net::LDAP->new($ldapserver) or die "ldap szerverkapcsolat sikertelen!\n";

$msg = $ldap->search(
                base => $basedn,
                scope => "sub",
                filter => "(ppkePersonOrgID=$neptun)" );

$entry = $msg->entry(0);
my $uid = eval { $entry->get_value( 'uid' ) };
$uid or $uid = undef;

$msg = $ldap->unbind;
return ($uid);
}

my $neptunkod = param('ppkepersonorgid');

if (!$neptunkod) {
    $neptunkod = "+";
    }

#my $user = ldapkeres (param('ppkepersonorgid'));
my $user = ldapkeres ($neptunkod);

if ($user) {
    $user = "$user\@login.ppke.hu";
    }

print header('application/json');
my $json->{"eppn"} = $user;
my $json_text = to_json($json);
print $json_text;
