#!/bin/bash
#2020.01.16
#created By F.E.K.
ver="OCR AUTO V1.5"

declare -A ocrhunconf

 if [ ! -f /etc/ocrauto-hun.conf ];then echo -e "\n/etc/ocrauto-hun.conf nem olvasható!\n";exit;fi

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
 if [[ $igazitottertek = :* ]];then igazitottertek=$(echo $igazitottertek|awk -F " " '{print $2}'|base64 --decode 2>&1);fi
}

while IFS="=" read -r kulcs ertek
 do
 igazitas
   if ! [[ -z "$igazitottkulcs" ]];then ocrhunconf[$igazitottkulcs]=$igazitottertek;fi
done </etc/ocrauto-hun.conf

 if [[ -z "${ocrhunconf[bejovo]}"|| -z "${ocrhunconf[eredmeny]}"|| -z "${ocrhunconf[temp]}" ]];then echo -e "Hiányos vagy sérült ocrauto-hun.conf!\n";exit;fi
 if [[ ! -d "${ocrhunconf[eredmeny]}" ]];then mkdir -p -m 767 "${ocrhunconf[eredmeny]}";fi
 if [[ ! -d "${ocrhunconf[bejovo]}" ]];then mkdir -p -m 767 "${ocrhunconf[bejovo]}";fi
 if [[ ! -d "${ocrhunconf[mentes]}" && ! -z "${ocrhunconf[mentes]}" ]];then mkdir -p -m 767 " ${ocrhunconf[mentes]}";fi
 if [[ ! -d "${ocrhunconf[temp]}" ]];then mkdir "${ocrhunconf[temp]}";fi

rm -fr ${ocrhunconf[temp]}*;export MAGICK_DISK_LIMIT=2GiB;export MAGICK_MEMORY_LIMIT=1GB;export MAGICK_AREA_LIMIT=256MP

echo -e "**** $ver - Inditva: $(date) ****\nkonfiguráció:\nBejövő: "${ocrhunconf[bejovo]}"\nEredmény: "${ocrhunconf[eredmeny]}"\nMentes: "${ocrhunconf[mentes]}"\nMunkakönyvtár: "${ocrhunconf[temp]}"\nAláírás: "${ocrhunconf[szerzo]}"\nCím: "${ocrhunconf[cim]}""

inotifywait -m -e create -e moved_to --format '%w%f' "${ocrhunconf[bejovo]}"|while read celpont
    do
	allomany=$(echo ${celpont##*/});nev=$(echo "${allomany%.*}");kiterjesztes=$(echo "${allomany##*.}"|tr '[:upper:]' '[:lower:]')
	echo "$(date) -- Feldolgozás alatt: $allomany"
	if ! [[ "$kiterjesztes" =~ ^(pdf|jpg|tiff|png|bmp)$ ]]
	    then
		mv "$celpont" "${ocrhunconf[eredmeny]}";echo "$(date) -- Érvénytelen formátum : $kiterjesztes"
	    else
		jog=$(stat -c%a "$celpont");tulaj=$(stat -c%U "$celpont");csoport=$(stat -c%G "$celpont")
		    if [ ! -z "${ocrhunconf[mentes]}" ];then cp "$celpont" "${ocrhunconf[mentes]}$allomany";fi
		mv "$celpont" "${ocrhunconf[temp]}$allomany"
		    if [ "$kiterjesztes" == "pdf" ]
			then
			    convert -density 300 -alpha remove -background white +matte "${ocrhunconf[temp]}$allomany" "${ocrhunconf[temp]}$nev.tiff"
			    tesseract "${ocrhunconf[temp]}$nev.tiff" "$eredmeny$nev" -l hun pdf
			    rm -f "${ocrhunconf[temp]}$nev.tiff"
			else
			    tesseract "${ocrhunconf[temp]}$allomany" "$eredmeny$nev" -l hun pdf 
		    fi
	    rm -f "${ocrhunconf[temp]}$allomany"
		if [[ ! -z "${ocrhunconf[szerzo]}"||"${ocrhunconf[cim]}" ]];then exiftool -Author="${ocrhunconf[szerzo]}" -Title="${ocrhunconf[cim]}" -overwrite_original "$eredmeny$nev.pdf";fi
	    chown $tulaj:$csoport "$eredmeny$nev.pdf";chmod $jog "$eredmeny$nev.pdf"
	    echo "$(date) -- Kész"
	fi
    done
